<?php

/**
* Gavick GK Weather - layout
* @package Joomla!
* @Copyright (C) 2009 Gavick.com
* @ All rights reserved
* @ Joomla! is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.0.0 $
**/

// no direct access
defined('_JEXEC') or die('Restricted access');

?>

<div class="gkw_main" id="<?php echo $this->config['module_unique_id']; ?>">
	<div class="gkw_current">
		<div class="gkw_main_left">
			<img src="<?php echo $this->icon($this->parsedData['current_icon'], $this->config['current_icon_size']); ?>" alt="<?php echo $this->parsedData['current_condition']; ?>" />
			<p class="gkw_temp"><?php echo ($this->config['tempUnit'] == 'f') ? $this->parsedData['current_temp_f'].'&deg;F' : $this->parsedData['current_temp_c'].'&deg;C'; ?></p>
		</div>
		<div class="gkw_main_right">
			<?php if($this->config['showCity'] == 1) : ?><h2><?php echo $this->config['fcity']; ?></h2><?php endif; ?>
			<p class="gkw_condition"><?php echo $this->parsedData['current_condition']; ?></p>
			<?php if($this->config['showHum'] == 1) : ?><p class="gkw_humidity"><?php echo $this->parsedData['current_humidity']; ?></p><?php endif; ?>
			<?php if($this->config['showWind'] == 1) : ?><p class="gkw_wind"><?php echo $this->parsedData['current_wind']; ?></p><?php endif; ?>
		</div>
	</div>
	<?php if($this->config['nextDays'] == 1) : ?>
	<ul class="gkw_next_days">
		<?php for($i = 0; $i < 4; $i++) : ?>
		<li>
			<span class="gkw_day"><?php echo $this->parsedData['forecast'][$i]['day']; ?></span>
			<img src="<?php echo $this->icon($this->parsedData['forecast'][$i]['icon'], $this->config['forecast_icon_size']); ?>" title="<?php echo $this->parsedData['forecast'][$i]['condition']; ?>" alt="<?php echo $this->parsedData['forecast'][$i]['condition']; ?>" />
			<p class="gkw_day_temp">
				<span class="gkw_day_day"><?php echo $this->temp($this->parsedData['forecast'][$i]['high']); ?></span>
				<span class="gkw_day_night"><?php echo $this->temp($this->parsedData['forecast'][$i]['low']); ?></span>
			</p>
		</li>
		<?php endfor; ?>
	</ul>
	<?php endif; ?>
</div>