<?php

/**
* Gavick GK Weather - helper class
* @package Joomla!
* @Copyright (C) 2009 Gavick.com
* @ All rights reserved
* @ Joomla! is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.0.0 $
**/

// no direct access
defined('_JEXEC') or die('Restricted access');
// Main class
class GKWHelper
{
	var $config;
	var $content;
	var $error;
	var $icons;
	var $parsedData;

	/**
	 * 
	 *	INITIALIZATION
	 * 
	 **/
	
	function init()
	{		
		// importing JFile class 
		jimport('joomla.filesystem.file');
		// configuration array
		$this->config = array(
			'module_unique_id' => '',				            
            'city' => '',
			'fcity' => '',
            'language' => 'en',
			'latitude' => 'null',
			'longitude' => 'null',
			'timezone' => 0,
			'showCity' => 1,
			'showHum' => 1,
			'showWind' => 1,
			'tempUnit' => 'c',
			'nextDays' => 1,
			'current_icon_size' => 64,
			'forecast_icon_size' => 32,
			'useCSS' => 1,
			'useCache' => 1,
			'cacheTime' => 5
		);	
		// error text
		$this->error = '';
		// icons array
		$this->icons = array(
			"/ig/images/weather/chance_of_snow.gif"  => array('chance_of_snow.png', 'chance_of_snow_night.png'),
			"/ig/images/weather/flurries.gif"        => array('flurries.png'),
			"/ig/images/weather/snow.gif"            => array('snow.png'),
			"/ig/images/weather/sleet.gif"           => array('sleet.png'),
			"/ig/images/weather/chance_of_rain.gif"  => array('chance_of_rain.png','chance_of_rain_night.png'),
			"/ig/images/weather/chance_of_storm.gif" => array('chance_of_storm.png','chance_of_storm_night.png'),
			"/ig/images/weather/mist.gif"            => array('mist.png','mist_night.png'),
			"/ig/images/weather/showers.gif"         => array('showers.png','showers_night.png'),
			"/ig/images/weather/rain.gif"            => array('rain.png'),
			"/ig/images/weather/storm.gif"           => array('storm.png','storm_night.png'),
			"/ig/images/weather/thunderstorm.gif"    => array('thunderstorm.png','thunderstorm_night.png'),
			"/ig/images/weather/rain_and_snow.gif"   => array('rain_and_snow.png'),
			"/ig/images/weather/sunny.gif"           => array('sunny.png','sunny_night.png'),
			"/ig/images/weather/mostly_sunny.gif"    => array('sunny.png','sunny_night.png'),
			"/ig/images/weather/partly_cloudy.gif"   => array('partly_cloudy.png','partly_cloudy_night.png'),
			"/ig/images/weather/mostly_cloudy.gif"   => array('mostly_cloudy.png','mostly_cloudy_night.png'),
			"/ig/images/weather/cloudy.gif"          => array('cloudy.png','cloudy_night.png'),
			"/ig/images/weather/fog.gif"             => array('foggy.png','foggy_night.png'),
			"/ig/images/weather/foggy.gif"           => array('foggy.png','foggy_night.png'),
			"/ig/images/weather/smoke.gif"           => array('smoke.png','smoke_night.png'),
			"/ig/images/weather/hazy.gif"            => array('hazy.png','hazy_night.png'),
			"/ig/images/weather/dusty.gif"           => array('dusty.png','dusty_night.png'),
			"/ig/images/weather/icy.gif"             => array('icy.png','icy_night.png')
 		);
		// parsed from XML data
		$this->parsedData = array(
			'unit' => '',
			'current_condition' => '',
			'current_temp_f' => '',
			'current_temp_c' => '',
			'current_humidity' => '',
			'current_icon' => '',
			'current_wind' => '',
			'forecast' => array()
		);
	}
	
	/**
	 * 
	 *	VARIABLES VALIDATION
	 * 
	 **/
	
	function validateVariables(&$params)
	{
		$this->config['module_unique_id'] = $params->get('module_unique_id','weather1'); // unique ID
        $this->config['city'] = str_replace(' ','%20',$params->get('city',''));
		$this->config['fcity'] = $params->get('fullcity','');
        $this->config['language'] = $params->get('language','en');
		$this->config['latitude'] = $params->get('lat','null');
		$this->config['longitude'] = $params->get('lon','null');
		$this->config['timezone'] = $params->get('timezone',0);
		$this->config['showCity'] = $params->get('showCity',1);
		$this->config['showHum'] = $params->get('showHum',1);
		$this->config['showWind'] = $params->get('showWind',1);
		$this->config['tempUnit'] = $params->get('tempUnit','c');
		$this->config['nextDays'] = $params->get('nextDays',1);
		$this->config['current_icon_size'] = $params->get('current_icon_size',64);
		$this->config['forecast_icon_size'] = $params->get('forecast_icon_size',32);
		$this->config['useCSS'] = $params->get('useCSS',1);
		$this->config['useCache'] = $params->get('useCache',1);
		$this->config['cacheTime'] = $params->get('cacheTime',5);
	}
	
	/**
	 * 
	 *	GETTING DATA
	 * 
	 **/
		
	function getData()
	{
		clearstatcache();
		
		if($this->config['useCache'] == 1)
		{
			if(filesize(realpath('cache/mod_gk_weather.xml')) == 0 || ((filemtime(realpath('cache/mod_gk_weather.xml')) + $this->config['cacheTime'] * 60) < time()))
			{
				if(function_exists('curl_init'))
				{
					// initializing connection
					$curl = curl_init();
					// saves us before putting directly results of request
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
					// url to get
					curl_setopt($curl, CURLOPT_URL, 'http://www.google.com/ig/api?weather='.$this->config['city'].'&hl='.$this->config['language']);
					// timeout in seconds
					curl_setopt($curl, CURLOPT_TIMEOUT, 20);
					// useragent
					curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
					// reading content
					$this->content = curl_exec($curl);
					// closing connection
					curl_close($curl);
				}
				else
				{
					$this->error = 'cURL extension is not available on your server';
				}
				// if error doesn't exist
				if($this->error == '')
				{
					// saving cache
					JFile::write(realpath('modules/mod_gk_weather/cache/mod_gk_weather.xml'), $this->content);
				}
			}
			else
			{
				$this->content = JFile::read(realpath('modules/mod_gk_weather/cache/mod_gk_weather.xml'));
			}
		}
		else
		{
			if(function_exists('curl_init'))
			{
				// initializing connection
				$curl = curl_init();
				// saves us before putting directly results of request
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
				// url to get
				curl_setopt($curl, CURLOPT_URL, 'http://www.google.com/ig/api?weather='.$this->config['city'].'&hl='.$this->config['language']);
				// timeout in seconds
				curl_setopt($curl, CURLOPT_TIMEOUT, 20);
				// useragent
				curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
				// reading content
				$this->content = curl_exec($curl);
				// closing connection
				curl_close($curl);
			}
			else
			{
				$this->error = 'cURL extension is not available on your server';
			}
		}
	}

	/**
	 * 
	 *	PARSING DATA
	 * 
	 **/
	 
	function parseData()
	{
		if($this->error === '')
		{
			// checking for 400 Bad request page
			if(strpos($this->content, '400 Bad') == FALSE)
			{		
				$xml =& JFactory::getXMLParser('Simple');
				
				if($xml->loadString($this->content))
				{
					// checking data correct
					if(!isset($xml->document->weather[0]->problem_cause[0]))
					{
						// preparing shortcuts
						$forecast_info = $xml->document->weather[0]->forecast_information[0];
						$current_conditions = $xml->document->weather[0]->current_conditions[0];
						// loading data from feed
						$this->parsedData['unit'] = $forecast_info->unit_system[0]->attributes('data');
						$this->parsedData['current_condition'] = $current_conditions->condition[0]->attributes('data');
						$this->parsedData['current_temp_f'] = $current_conditions->temp_f[0]->attributes('data');
						$this->parsedData['current_temp_c'] = $current_conditions->temp_c[0]->attributes('data');
						$this->parsedData['current_humidity'] = $current_conditions->humidity[0]->attributes('data');
						$this->parsedData['current_icon'] = $current_conditions->icon[0]->attributes('data');
						$this->parsedData['current_wind'] = $current_conditions->wind_condition[0]->attributes('data');
						// parsing forecast
						for($i = 0; $i < 4; $i++)
						{
							$node = $xml->document->weather[0]->forecast_conditions[$i];
							$this->parsedData['forecast'][$i] = array(
								"day" => $node->day_of_week[0]->attributes('data'),
								"low" => $node->low[0]->attributes('data'),
								"high" => $node->high[0]->attributes('data'),
								"icon" => $node->icon[0]->attributes('data'),
								"condition" => $node->condition[0]->attributes('data')
							);
						}
					}
					else // if specified location doesn't exist
					{
						$this->error = 'An error occured - you set wrong location or data for your location are unavailable';
					}
				}
				else
				{
					// set error
					$this->error = 'Parse error in downloaded data';
				}
			}
			else
			{
				// set error
				$this->error = 'Parse error in downloaded data (400)';
			}
		}
	}
	
	/**
	 * 
	 *	RENDERING LAYOUT
	 * 
	 **/
	
	function renderLayout()
	{	
		// if any error exists
		if($this->error === '')
		{
			/**
				GENERATING FINAL XHTML CODE START
			**/

			// create instances of basic Joomla! classes
			$document =& JFactory::getDocument();
			$uri =& JURI::getInstance();
			// add stylesheets to document header
			if($this->config["useCSS"] == 1){
				$document->addStyleSheet( $uri->root().'modules/mod_gk_weather/style/style.css', 'text/css' );
			}
			//
			require(JModuleHelper::getLayoutPath('mod_gk_weather', 'default'));
		}
		else // else - output error information
		{
			echo $this->error;
		}
	}
	
	/*
	*
	* Function to get correct icon
	*
	*/
	
	function icon($icon, $size = 128)
	{
		// creating JURI instance
		$uri =& JURI::getInstance();
		// if selected icon exists
		if(is_array($this->icons[$icon]))
		{
			// if user use PHP5
			if(function_exists('date_sunrise') && function_exists('date_sunset'))
			{
				// if user set values for his position
				if($this->config['latitude'] !== 'null' && $this->config['longitude'] !== 'null')
				{
					// getting informations about sunrise and sunset time
					$sunrise = date_sunrise( time(), SUNFUNCS_RET_TIMESTAMP , $this->config['latitude'], $this->config['longitude'], ini_get("date.sunrise_zenith"), $this->config['timezone'] );
					$sunset = date_sunset( time(), SUNFUNCS_RET_TIMESTAMP , $this->config['latitude'], $this->config['longitude'], ini_get("date.sunrise_zenith"), $this->config['timezone'] );
					// flag for night ;)
					$night = false;
					// night check ;)
					if(time() < $sunrise || time() > $sunset)
					{
						// now is night! :P
						$night = true;
					}
					// getting final icon
					// if selected icon has two icons - for day and night
					if(count($this->icons[$icon]) > 1)
					{
						// night icon
						if($night === true)
						{
							return $uri->root().'modules/mod_gk_weather/icons/'.(($size == 128) ? '' : $size.'/').$this->icons[$icon][1];
						}
						else // day icon
						{
							return $uri->root().'modules/mod_gk_weather/icons/'.(($size == 128) ? '' : $size.'/').$this->icons[$icon][0];
						}
					}
					else // for icons which are the same for day and night
					{
						return $uri->root().'modules/mod_gk_weather/icons/'.(($size == 128) ? '' : $size.'/').$this->icons[$icon][0];
					}
				}
				else
				{
					return $uri->root().'modules/mod_gk_weather/icons/'.(($size == 128) ? '' : $size.'/').$this->icons[$icon][0];
				}
			}
			else
			{
				return $uri->root().'modules/mod_gk_weather/icons/'.(($size == 128) ? '' : $size.'/').$this->icons[$icon][0];
			}
		}
		else // else - return "?" icon
		{
			return $uri->root().'modules/mod_gk_weather/icons/'.(($size == 128) ? '' : $size.'/').'other.png';
		}
	}
	
	/*
	*
	* Function to get correct temperature
	*
	*/
	
	function temp($temp)
	{
		require_once('units.php');
	
		if($this->parsedData['unit'] == 'US' && $this->config['tempUnit'] == 'c')
		{
			return F2Cel($temp);
		}
		else if($this->parsedData['unit'] == 'SI' && $this->config['tempUnit'] == 'f')
		{
			return Cel2F($temp);
		}
		else
		{
			return $temp.(($this->config['tempUnit'] == 'c') ? '&deg;C' : '&deg;F' );
		}		
	}
}

?>