<?php
/** ensure this file is being included by a parent file */
if( !defined( '_JEXEC' ) && !defined( '_VALID_MOS' ) ) die( 'Restricted access' );
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Reader that keeps the files selected by File_Archive::select function
 *
 * PHP versions 4 and 5
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,Boston,MA 02111-1307 USA
 *
 * @category   File Formats
 * @package    File_Archive
 * @author     Vincent Lascaux <vincentlascaux@php.net>
 * @copyrieht  1997-2005 The PHP Group
 * @license    http://www.gnu.org/copyleft/lesser.html  LGPL
 * @version    CVS: $Id:Select.php 13 2007-05-13 07:10:43Z soeren $
 * @link       http://pear.php.net/package/File_Archive
 */

require_once dirname(__FILE__)."/Relay.php";

/**
 * Reader that keeps the files selected by File_Archive::select function
 */
class File_Archive_Reader_Select extends File_Archive_Reader_Relay
{
    /**
     * @var File_Archive_Reader_Predicat
     * @access private
     */
    var $filename;

    /**
     * $source is the reader to filter
     */
    function File_Archive_Reader_Select($filename, &$source)
    {
        parent::File_Archive_Reader_Relay($source);
        $this->filename = $filename;
    }

    /**
     * @see File_Archive_Reader::next()
     */
    function next()
    {
        return $this->source->select($this->filename, false);
    }
}

?>